function [x,iter] = gpu_DenEELSInt(Image,Gain,VAR,IntDev,lambda1,lambda2,NIter)

%% Initialize
Image   = gpuArray(Image);
VAR     = gpuArray(VAR);
Gain    = gpuArray(Gain);
IntDev  = gpuArray(IntDev);


gamma   = gpuArray(1);
gamma_0 = gpuArray(1);
eta     = gpuArray(1);
lim     = gpuArray(10);
Lim     = gpuArray(100);

lambda1 = gpuArray(lambda1);
lambda2 = gpuArray(lambda2);


SizeImg = size(Image);

z0      = Image;
z1x     = zeros(SizeImg,'gpuArray');
z1y     = zeros(SizeImg,'gpuArray');
z2x     = zeros(SizeImg,'gpuArray');
z2xy    = zeros(SizeImg,'gpuArray');
z2y     = zeros(SizeImg,'gpuArray');

u0      = zeros(SizeImg,'gpuArray');
u1x     = zeros(SizeImg,'gpuArray');
u1y     = zeros(SizeImg,'gpuArray');
u2x     = zeros(SizeImg,'gpuArray');
u2xy    = zeros(SizeImg,'gpuArray');
u2y     = zeros(SizeImg,'gpuArray');

x       = zeros(SizeImg,'gpuArray');
T1      = zeros(SizeImg,'gpuArray');
T2      = zeros(SizeImg,'gpuArray');


%% Total Generalalized Variation
dx  = gpuArray([1,-1,0]) ;
dy  = gpuArray([1,-1,0])';
dx  = fftn(dx,SizeImg);
dy  = fftn(dy,SizeImg);
dtx = conj(dx);
dty = conj(dy);


DtD = dtx.*dx + dty.*dy;

A11 = gamma_0 + gamma.*(DtD) ; A12 =       - gamma.*       (dtx) ; A13 =       - gamma.*       (dty) ;
A21 =         - gamma.*(dx ) ; A22 = gamma + eta  .*(DtD)        ; A23 =       + eta  .*(dy ).*(dtx) ;
A31 =         - gamma.*(dy ) ; A32 =       + eta  .*(dx ).*(dty) ; A33 = gamma + eta  .*(DtD)        ;


detA = 1./ ((A11.*A22.*A33) + (A12.*A23.*A31) + (A13.*A21.*A32) - (A31.*A22.*A13) - (A32.*A23.*A11) - (A33.*A21.*A12));

iA11 =  (A22.*A33 - A32.*A23) .* detA ; iA21 = -(A21.*A33 - A31.*A23) .* detA ; iA31 =  (A21.*A32 - A31.*A22) .* detA;
iA12 = -(A12.*A33 - A32.*A13) .* detA ; iA22 =  (A11.*A33 - A31.*A13) .* detA ; iA32 = -(A11.*A32 - A31.*A12) .* detA;
clearvars A32 A33
iA13 =  (A12.*A23 - A22.*A13) .* detA ; iA23 = -(A11.*A23 - A21.*A13) .* detA ; iA33 =  (A11.*A22 - A21.*A12) .* detA;
clearvars detA A11 A12 A13   A21 A22 A23

%% Start ADMM iterations
WaitTics         = NIter;
WaitADMM         = parfor_wait(WaitTics, 'Waitbar', true,'ReportInterval',1);

for iter=1:NIter
    RBCyc = ~mod(iter,round(10^(round(log10(iter)*10)/10))) || iter<10 || iter==NIter;
    
    %% X and T Updates
    v0    =  z0    - u0 ;
    v1x   =  z1x  - u1x ;
    v1y   =  z1y  - u1y ;
    
    v2x   =  z2x  - u2x ;
    v2xy  =  z2xy - u2xy;
    v2y   =  z2y  - u2y ;
    
    xnum1 =    gamma_0.*fftn(v0,SizeImg)  + gamma.*fftn(Dt(v1x ,2),SizeImg) + gamma.*fftn(Dt(v1y ,1),SizeImg);
    clearvars v0
    xnum2 =  - gamma  .*fftn(v1x,SizeImg) + eta  .*fftn(D( v2x ,2),SizeImg) + eta  .*fftn(D( v2xy,1),SizeImg);
    clearvars v1x v2x
    xnum3 =  - gamma  .*fftn(v1y,SizeImg) + eta  .*fftn(D( v2xy,2),SizeImg) + eta  .*fftn(D( v2y ,1),SizeImg);
    clearvars v1y v2y v2xy
    
    if RBCyc
        x_old  = x;
        T1_old = T1;
        T2_old = T2;
    end
    
    x     = iA11.*xnum1 + iA12.*xnum2 + iA13.*xnum3;
    T1    = iA21.*xnum1 + iA22.*xnum2 + iA23.*xnum3;
    T2    = iA31.*xnum1 + iA32.*xnum2 + iA33.*xnum3;
    clearvars xnum1 xnum2 xnum3
    
    x     = ifftn(x ,SizeImg);
    T1    = ifftn(T1,SizeImg);
    T2    = ifftn(T2,SizeImg);
    
    x     = sign(real(x )).*abs(x );
    T1    = sign(real(T1)).*abs(T1);
    T2    = sign(real(T2)).*abs(T2);
    
    if RBCyc
        x_old  = x  -  x_old;
        T1_old = T1 - T1_old;
        T2_old = T2 - T2_old;
    end
    
    %% Check Waitbar exist
    Flag = CheckWaitbar(WaitADMM);
    switch Flag
        case 1
            x  = [];
            x  = gather(x);
            clearvars -except x iter
            return
        case 2
            x = gather(x);
            clearvars -except x iter
            return
    end
    clearvars Flag
    
    %% Z Update
    v0     = x + u0;
    if RBCyc
        z0_old = z0;
    end
    z0     = MPG(Image,z0,v0,gamma_0,Gain,IntDev,VAR,1);
    u0     = v0 - z0;
    clearvars v0
    if RBCyc
        S0        = -gamma_0.*(z0 - z0_old);
        clearvars z0_old
        S0norm    =  gamma_0.*u0;
        
        R0        = sqrt(mean((x - z0).^2,'all'));
        R0norm    = sqrt(max(mean(x.^2,'all'),mean(z0.^2,'all')));
        Rnorm0    = R0/R0norm;
        clearvars R0 R0norm
    end
    %% Z1 update
    Dx    = D(x,2);
    v1x   = Dx - T1 + u1x;
    
    Dy    = D(x,1);
    v1y   = Dy - T2 + u1y;
    
    k     = lambda1/gamma;
    vnorm = sqrt(v1x.^2 + v1y.^2);
    
    if RBCyc
        z1x_old = z1x;
    end
    z1x   = cSk(v1x,vnorm,k);
    u1x   = v1x - z1x;
    clearvars v1x
    if RBCyc
        z1x_old   =          z1x       - z1x_old   ;
        S         = -gamma.*Dt(T1_old    + z1x_old,2);
        S1norm    =  gamma.*Dt(u1x                ,2);
        
        S1a       =  gamma.*(D(-x_old,2) + z1x_old  );
        clearvars z1x_old
        S1anorm   =  gamma.*u1x;
        
        R         = mean((Dx - z1x - T1).^2,'all');
        R1norm    = mean((Dx       - T1).^2,'all');
        R2norm    = mean((     z1x     ).^2,'all');
    end
    clearvars Dx
    
    if RBCyc
        z1y_old = z1y;
    end
    z1y   = cSk(v1y,vnorm,k);
    clearvars vnorm
    u1y   = v1y - z1y;
    clearvars v1y
    if RBCyc
        z1y_old   =             z1y       - z1y_old    ;
        S         = S - gamma.*Dt(T2_old    + z1y_old ,1);
        S2norm    =     gamma.*Dt(u1y                 ,1);
        
        S2a       =     gamma.*(D(-x_old,1) + z1y_old   );
        clearvars z1y_old
        S2anorm   =     gamma.*u1y;
        
        SN0       =  max(mean( S0norm.^2          ,'all'),mean((S1norm + S2norm - S ).^2,'all'));
        SN        =  max(mean((S1norm + S2norm).^2,'all'),mean((S0norm          - S0).^2,'all'));
        clearvars S0norm Spnorm S1norm S2norm
        
        Snorm0    = sqrt(mean(S0.^2,'all')/SN0);
        clearvars S0 SN0
        S         = sqrt(mean(S.^2,'all') + mean(S1a.^2,'all') + mean(S2a.^2,'all'));
        
        R         = sqrt(R      + mean((Dy - z1y - T2).^2,'all'));
        R1norm    =      R1norm + mean((Dy       - T2).^2,'all') ;
        R2norm    =      R2norm + mean((     z1y     ).^2,'all') ;
        
        RN        = sqrt(max(R1norm,R2norm));
        clearvars R1norm R2norm
        
        Rnorm     = R/RN;
        clearvars R RN
    end
    clearvars Dy
    
    %% Z2 Update
    Htx   = Dt(T1,2);
    v2x   = Htx  + u2x;
    
    Htxy  = Dt(T1,1) + Dt(T2,2);
    v2xy  = Htxy + u2xy;
    
    Hty   = Dt(T2,1);
    v2y   = Hty  + u2y;
    
    k     = lambda2/eta;
    vnorm = sqrt(v2x.^2 + v2xy.^2 + v2y.^2 );
    
    if RBCyc
        z2x_old = z2x;
    end
    z2x   = cSk(v2x ,vnorm,k);
    u2x   = v2x  - z2x ;
    clearvars v2x
    if RBCyc
        s1        = - eta.*D(z2x - z2x_old,2);
        clearvars z2x_old
        s1norm    =   eta.*D(u2x          ,2);
        
        r         = mean((Htx - z2x).^2,'all');
        r1norm    = mean((Htx      ).^2,'all');
        r2norm    = mean((      z2x).^2,'all');
    end
    clearvars Htx
    
    if RBCyc
        z2xy_old = z2xy;
    end
    z2xy  = cSk(v2xy,vnorm,k);
    u2xy  = v2xy - z2xy;
    clearvars v2xy
    if RBCyc
        z2xy_old  =                     z2xy      - z2xy_old    ;
        s1        = s1     - eta.*D(Dt(-T2_old,2) + z2xy_old ,1);
        s1norm    = s1norm + eta.*D(                u2xy    , 1);
        s         =          mean(s1.^2,'all');
                
        sn        =      max(mean((S1anorm - S1a).^2,'all') ,  mean(s1norm.^2 ,'all'));
        clearvars S1a 
        SN        = SN + max(mean((s1norm  - s1 ).^2,'all') ,  mean(S1anorm.^2,'all'));
        clearvars S1anorm s1 s1norm 
        
        s2        =        - eta.*D(Dt(-T1_old,1) + z2xy_old ,2);
        clearvars z2xy_old
        s2norm    =          eta.*D(                u2xy    , 2);
        
        r         = r      + mean((Htxy - z2xy).^2,'all');
        r1norm    = r1norm + mean((Htxy       ).^2,'all');
        r2norm    = r2norm + mean((       z2xy).^2,'all');
    end
    clearvars Htxy
    
    if RBCyc
        z2y_old = z2y;
    end
    z2y   = cSk(v2y ,vnorm,k);
    u2y   = v2y  - z2y ;
    clearvars v2y vnorm
    if RBCyc
        s2        = s2     - eta.*(D(z2y - z2y_old,1));
        clearvars z2y_old
        s2norm    = s2norm + eta.*(D(      u2y    ,1));
        s         = sqrt(s      + mean(s2.^2,'all'));
        
        sn        = sqrt(sn + max(mean((S2anorm - S2a).^2,'all') ,  mean(s2norm.^2 ,'all')));
        clearvars S2a
        SN        = sqrt(SN + max(mean((s2norm  - s2 ).^2,'all') ,  mean(S2anorm.^2,'all')));
        clearvars S2anorm s2 s2norm
        
        snorm     = s/sn;
        clearvars s sn
        Snorm     = S/SN;
        clearvars S SN
        
        r         = sqrt(r      + mean((Hty - z2y).^2,'all'));
        r1norm    =      r1norm + mean((Hty      ).^2,'all') ;
        r2norm    =      r2norm + mean((      z2y).^2,'all') ;
        rn        = sqrt(max(r1norm,r2norm));
        clearvars r1norm r2norm
        rnorm     = r/rn;
        clearvars r rn
    end
    clearvars Hty
    
    if RBCyc
        %% Rho0 Update (RB)
        tau_gamma_0 = sqrt(Rnorm0/Snorm0);
        if isnan(tau_gamma_0) || tau_gamma_0==0 || tau_gamma_0==inf
            if gamma_0 > 1
                tau_gamma_0 = lim^(-1);
            elseif gamma_0 < 1
                tau_gamma_0 = lim^( 1);
            else
                tau_gamma_0 = 1;
            end
        end
        tau_gamma_0 = max(min(tau_gamma_0,10^(Lim)/gamma_0),10^(-Lim)/gamma_0);
        gamma_0     = gamma_0.*tau_gamma_0;
        u0          =    u0  ./tau_gamma_0;
        
        %% Rho Update (RB)
        tau_gamma = sqrt(Rnorm/Snorm);
        if isnan(tau_gamma) || tau_gamma==0 || tau_gamma==inf
            if gamma > 1
                tau_gamma = lim^(-1);
            elseif gamma < 1
                tau_gamma = lim^( 1);
            else
                tau_gamma = 1;
            end
        end
        tau_gamma = max(min(tau_gamma,10^(Lim)/gamma),10^(-Lim)/gamma);
        gamma     = gamma.*tau_gamma;
        u1x       =   u1x./tau_gamma;
        u1y       =   u1y./tau_gamma;
        
        %% Eta Update (RB)
        tau_eta = sqrt(rnorm/snorm);
        if isnan(tau_eta) || tau_eta==0 || tau_eta==inf
            if eta > 1
                tau_eta = lim^(-1);
            elseif eta < 1
                tau_eta = lim^( 1);
            else
                tau_eta = 1;
            end
        end
        tau_eta = max(min(tau_eta,10^(Lim)/eta),10^(-Lim)/eta);
        eta     = eta .*tau_eta;
        u2x     = u2x ./tau_eta;
        u2xy    = u2xy./tau_eta;
        u2y     = u2y ./tau_eta;
        
        %% Update Denominator
        if tau_gamma_0 ~=1 && tau_gamma ~=1 && tau_eta~=1
            A11 = gamma_0 + gamma.*(DtD) ; A12 =       - gamma.*       (dtx) ; A13 =       - gamma.*       (dty) ;
            A21 =        - gamma.*(dx ) ; A22 = gamma + eta  .*(DtD)        ; A23 =       + eta  .*(dy ).*(dtx) ;
            A31 =        - gamma.*(dy ) ; A32 =       + eta  .*(dx ).*(dty) ; A33 = gamma + eta  .*(DtD)        ;
            
            
            detA = 1./ ((A11.*A22.*A33) + (A12.*A23.*A31) + (A13.*A21.*A32) - (A31.*A22.*A13) - (A32.*A23.*A11) - (A33.*A21.*A12));
            
            iA11 =  (A22.*A33 - A32.*A23) .* detA ; iA21 = -(A21.*A33 - A31.*A23) .* detA ; iA31 =  (A21.*A32 - A31.*A22) .* detA;
            iA12 = -(A12.*A33 - A32.*A13) .* detA ; iA22 =  (A11.*A33 - A31.*A13) .* detA ; iA32 = -(A11.*A32 - A31.*A12) .* detA;
            clearvars A32 A33
            iA13 =  (A12.*A23 - A22.*A13) .* detA ; iA23 = -(A11.*A23 - A21.*A13) .* detA ; iA33 =  (A11.*A22 - A21.*A12) .* detA;
            clearvars detA A11 A12 A13   A21 A22 A23
        end
    end
    
    %% Check Waitbar exist
    Flag = CheckWaitbar(WaitADMM);
    switch Flag
        case 1
            x  = [];
            x  = gather(x);
            clearvars -except x iter
            return
        case 2
            x  = gather(x);
            clearvars -except x iter
            return
    end
    clearvars Flag
    WaitADMM.Send;
    
end
WaitADMM.Destroy;
x = gather(x);
clearvars -except x iter

end


function z = MPG(Image,z,v,gamma,Gain,k,VAR,NewtIter)
z(z<0)=0;

for i=1:NewtIter
    zImg       = z - Image;
    den        = Gain.*z + k.^2.*z.^2 + VAR;
    kGain      = Gain + 2.*k.^2.*z;
    zImgden    = zImg./den;
    kden       = kGain./den;
    kden2      = kden.^2;
    zImg2den2  = zImgden.^2;
    
    fx      = zImgden - 1/2.*zImg2den2.*kGain + 1/2.*kden - gamma.*(v - z);
    
    dfx     = (1+k.^2)./den - 2.*zImgden.*kden - k.^2.*zImg2den2 + kden2.*zImgden.*zImg - 1/2.*kden2 + gamma;
    clearvars zImg den k zImgden kden zImg2den2 kden2 zImg2den2k
    z       = z - fx./dfx;
    clearvars fx dfx
    z(z<0)=0;
end
clearvars -except z
end

function z = cSk(v1,vnorm,k)
z           = zeros(size(v1),'gpuArray');
z(vnorm>=k) = v1(vnorm>=k)- k * v1(vnorm>=k)./vnorm(vnorm>=k);
clearvars -except z
end

function Grad = D(x,dim)
Grad        = x - circshift(x,+1,dim);
clearvars -except Grad
end

function Grad = Dt(x,dim)
Grad        = x - circshift(x,-1,dim);
clearvars -except Grad
end